/***********************************************************************
*
* Text Edit routines in C
*
* Copyright (c) SSSi, 1989, 1990.
* All Rights Reserved.
*
***********************************************************************/

segment "M_WOLFGRAM";

#include "genesys.h"
#include <types.h>
#include <control.h>
#include <font.h>
#include <gsos.h>
#include <menu.h>
#include <memory.h>
#include <stdfile.h>
#include <quickdraw.h>
#include <qdaux.h>
#include <textedit.h>
#include <window.h>

#define TEid 0x1000L

extern int MasterID;
extern LongWord DrawProc;
extern long monoFormat;

void shError(int, int);
int toolerror(void);

struct winRefCon {
    Word        winResType;
    LongWord    winResID;
    Word        winType;
    GrafPortPtr winOwner;
};
typedef struct winRefCon **winRefConHndl;

struct specialType {
    Word    cnt;
    Word    fileData1[2];
    long    auxt1;
    Word    fileData2[2];
    long    auxt2;
} fileTypes = { 2, 0x8000, 0x04, 0L, 0x8000, 0xb0, 0L };

int putFileIntoWindow(c1hndl)
/************************************************************************
*
* This routine opens the specified file, reads its contents in and sets
* the text of the text edit control of the top window to that text.
*
************************************************************************/
char   **c1hndl;
{
   GSString255     *c1ptr;
   OpenRecGS       openBlock;
   RefNumRecGS     closeBlock;
   IORecGS         readBlock;
   Handle          theHndl;
   int             err;
   char            *cvt, *end;

   HLock(c1hndl);
   c1ptr = (GSString255 *)(*c1hndl + 2);

   openBlock.pCount = 15;              /* Open the indicated file. */
   openBlock.pathname = c1ptr;
   openBlock.requestAccess = 0;
   openBlock.resourceNumber = 0;
   openBlock.optionList = NULL;

   OpenGS(&openBlock);                 /* Error -- give it up. */
   if (err = toolerror()) {
       shError(err, 0x3010);
       HUnlock(c1hndl);
       return err;
   }

   closeBlock.pCount = 1;              /* Get ready to close file. */
   closeBlock.refNum = openBlock.refNum;

   theHndl = NewHandle(openBlock.eof, MasterID, 0, NULL);    /* Make a handle for file. */
   if (err = toolerror()) {
       shError(err, 0x3020);
       CloseGS(&closeBlock);
       shError(toolerror(), 0x3021);
       HUnlock(c1hndl);
       return err;
   }
   HLock(theHndl);

   readBlock.pCount = 4;               /* Read the file. */
   readBlock.refNum = openBlock.refNum;
   readBlock.dataBuffer = *theHndl;
   readBlock.requestCount = openBlock.eof;
   ReadGS(&readBlock);

   if (err = toolerror()) {         /* Error -- give it up. */
       shError(err, 0x3030);
       CloseGS(&closeBlock);
       shError(toolerror(), 0x3031);
       DisposeHandle(theHndl);
       shError(toolerror(), 0x3232);
       HUnlock(c1hndl);
       return err;
   }

    CloseGS(&closeBlock);               /* Almost made it -- oh well. */
    if (err = toolerror()) {
        shError(toolerror(), 0x3040);
        DisposeHandle(theHndl);
        shError(toolerror(), 0x3041);
        HUnlock(c1hndl);
        return err;
    }

    cvt = (char *) *theHndl;
    end = cvt + openBlock.eof;
    while (cvt < end) {
        *cvt &= 0x7f;
        cvt++;
    }

    TESetText(
        teDataIsTextBlock+teRefIsHandle*8,          /* Text Descriptor  */
        theHndl,                                    /* Text Ref         */
        0L,                                         /* Text Length      */
        0,                /* pointer */             /* Style Descriptor */
        &monoFormat,                                /* Style Ref        */
        GetCtlHandleFromID(FrontWindow(),TEid));    /* Control Handle   */
    shError(toolerror(), 0x3050);
    DisposeHandle(theHndl);
    shError(toolerror(), 0x3251);
    HUnlock(c1hndl);
    return 0;
}

int doOpenWindow()
/******************************************************************************
*
* This routine asks the user what file to open and opens it.
*
******************************************************************************/
{

    SFReplyRec2     myReply;
    GrafPortPtr     wPtr;
    char            *pstr;
    winRefConHndl   refCon;
    int             terr;

    myReply.nameRefDesc = teRefIsNewHandle;
    myReply.pathRefDesc = teRefIsNewHandle;
    SFGetFile2(
        125, 35,
        teRefIsPtr,
        "\pSelect a file...",
        NULL,           /* filter proc */
        &fileTypes,     /* type list   */
        &myReply
    );
    terr = toolerror();
    shError(terr, 0x3110);

    if (myReply.good && !terr) {

        WaitCursor();

        pstr = *(char **)myReply.nameRef; /* Convert C1OutputStr to PString */
        pstr[3] = pstr[2];
        pstr += 3;

        HLock(myReply.nameRef);

        wPtr = NewWindow2(
            pstr,                   /* Title reference          */
            NULL,                   /* Ref con                  */
            &DrawProc,              /* Draw routine             */
            NULL,                   /* DefProc pointer          */
            2,                      /* Param Table Descriptor   */
            0xFFBL,                 /* Param Table Reference    */
            rWindParam1             /* Param Table Type         */
        );
        shError(toolerror(), 0x3120);

        refCon = (winRefConHndl) NewHandle(12L, MasterID, 0, NULL);
        shError(toolerror(), 0x3122);
        SetWRefCon(refCon, wPtr);
        shError(toolerror(), 0x3123);

        (**refCon).winResType = 0;
        (**refCon).winResID = 0L;
        (**refCon).winType = 0x5754;    /* TW - text window */
        (**refCon).winOwner = NIL;

        SetPort(wPtr);

        terr = putFileIntoWindow(myReply.pathRef);

        DisposeHandle(myReply.nameRef);
        shError(toolerror(), 0x3124);
        DisposeHandle(myReply.pathRef);
        shError(toolerror(), 0x3125);

        InitCursor();
    }

    return terr;
}

int    closeTEWin()
/************************************************************************
* Inputs: None.
* Action: This routine closes the TE window.
* Output: WORD; 0 = window closed, -1 = not a text edit window.
* Notes : MUST HAVE CHECKED TO SEE OF NDA OR ROOT WINDOW BEFORE CALLING!
************************************************************************/
{
   winRefConHndl   refCon;

   refCon = (winRefConHndl) GetWRefCon(FrontWindow()); /* get win's ref con */
   shError(toolerror(), 0x3210);
   if ((**refCon).winType != 0x5754) return -1;        /* not ours, so OUT! */

   DisposeHandle((handle) refCon);             /* dispose ref con handle   */
   shError(toolerror(), 0x3216);

   CloseWindow(FrontWindow());                 /* close the sucker!        */
   shError(toolerror(), 0x3220);

   return 0;                                   /* tell shell we closed it  */
}
